<?php
/**
 * Class that operate on table 'tamweenremainstatus'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2021-01-02 07:29
 */
class TamweenremainstatusMySqlDAO implements TamweenremainstatusDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TamweenremainstatusMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM tamweenremainstatus WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM tamweenremainstatus';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM tamweenremainstatus ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param tamweenremainstatu primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM tamweenremainstatus WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TamweenremainstatusMySql tamweenremainstatu
 	 */
	public function insert($tamweenremainstatu){
		$sql = 'INSERT INTO tamweenremainstatus (clientid, month, remainstatus, userid, sysdate, del) VALUES (?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tamweenremainstatu->clientid);
		$sqlQuery->set($tamweenremainstatu->month);
		$sqlQuery->setNumber($tamweenremainstatu->remainstatus);
		$sqlQuery->setNumber($tamweenremainstatu->userid);
		$sqlQuery->set($tamweenremainstatu->sysdate);
		$sqlQuery->setNumber($tamweenremainstatu->del);

		$id = $this->executeInsert($sqlQuery);	
		$tamweenremainstatu->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TamweenremainstatusMySql tamweenremainstatu
 	 */
	public function update($tamweenremainstatu){
		$sql = 'UPDATE tamweenremainstatus SET clientid = ?, month = ?, remainstatus = ?, userid = ?, sysdate = ?, del = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($tamweenremainstatu->clientid);
		$sqlQuery->set($tamweenremainstatu->month);
		$sqlQuery->setNumber($tamweenremainstatu->remainstatus);
		$sqlQuery->setNumber($tamweenremainstatu->userid);
		$sqlQuery->set($tamweenremainstatu->sysdate);
		$sqlQuery->setNumber($tamweenremainstatu->del);

		$sqlQuery->setNumber($tamweenremainstatu->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM tamweenremainstatus';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByClientid($value){
		$sql = 'SELECT * FROM tamweenremainstatus WHERE clientid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByMonth($value){
		$sql = 'SELECT * FROM tamweenremainstatus WHERE month = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByRemainstatus($value){
		$sql = 'SELECT * FROM tamweenremainstatus WHERE remainstatus = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUserid($value){
		$sql = 'SELECT * FROM tamweenremainstatus WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySysdate($value){
		$sql = 'SELECT * FROM tamweenremainstatus WHERE sysdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDel($value){
		$sql = 'SELECT * FROM tamweenremainstatus WHERE del = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByClientid($value){
		$sql = 'DELETE FROM tamweenremainstatus WHERE clientid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByMonth($value){
		$sql = 'DELETE FROM tamweenremainstatus WHERE month = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByRemainstatus($value){
		$sql = 'DELETE FROM tamweenremainstatus WHERE remainstatus = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUserid($value){
		$sql = 'DELETE FROM tamweenremainstatus WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySysdate($value){
		$sql = 'DELETE FROM tamweenremainstatus WHERE sysdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDel($value){
		$sql = 'DELETE FROM tamweenremainstatus WHERE del = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TamweenremainstatusMySql 
	 */
	protected function readRow($row){
		$tamweenremainstatu = new Tamweenremainstatu();
		
		$tamweenremainstatu->id = $row['id'];
		$tamweenremainstatu->clientid = $row['clientid'];
		$tamweenremainstatu->month = $row['month'];
		$tamweenremainstatu->remainstatus = $row['remainstatus'];
		$tamweenremainstatu->userid = $row['userid'];
		$tamweenremainstatu->sysdate = $row['sysdate'];
		$tamweenremainstatu->del = $row['del'];

		return $tamweenremainstatu;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TamweenremainstatusMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>